#! /usr/bin/python

import os, subprocess, sys, datetime, cmd, locale, pprint, shlex
from time import mktime, sleep,strftime
import EXIF
from dropbox import client, rest, session
import contextlib, errno
import filecmp
import socket
import logging

import config

class StoredSession(session.DropboxSession):
	"""a wrapper around DropboxSession that stores a token to a file on disk"""
	
	def load_creds(self):
			try:
				stored_creds = open(config.DROPBOX_TOKEN_FILE).read()
				self.set_token(*stored_creds.split('|'))
			except IOError:
				pass # don't worry if it's not there

	def write_creds(self, token):
		f = open(config.DROPBOX_TOKEN_FILE, 'w')
		f.write("|".join([token.key, token.secret]))
		f.close()

	def delete_creds(self):
		os.unlink(config.DROPBOX_TOKEN_FILE)

	def link(self):
		request_token = self.obtain_request_token()
		url = self.build_authorize_url(request_token)
		print "url:", url
		print "Please authorize in the browser. After you're done, press enter."
		raw_input()

		self.obtain_access_token(request_token)
		self.write_creds(self.token)

	def unlink(self):
		self.delete_creds()
		session.DropboxSession.unlink(self)


# Lockfile implementation adapted from http://code.activestate.com/recipes/576572/
@contextlib.contextmanager
def flock(path):
    while True:
        try:
            fd = os.open(path, os.O_CREAT | os.O_EXCL | os.O_RDWR)
        except OSError, e:
            if e.errno != errno.EEXIST:
                raise            

            sys.exit('Another instance of this script (%s) is already running, exiting' % os.path.realpath(__file__))
            continue
        else:
            break
    try:
        yield fd
    finally:        
        os.unlink(path)

def get_file_list(directory, thumb = False):
	files = []
	for dirname, dirnames, filenames in os.walk(directory):

		for subdirname in dirnames:			 
			path = os.path.join(dirname[len(directory):], subdirname + os.sep)
			if path not in config.IGNORE_PATHS:
				files.append(path) 
		for filename in filenames:
			if dirname not in config.IGNORE_PATHS:
				if os.path.splitext(filename)[1].lower() in config.IMAGE_TYPES:
					if thumb:
						files.append(os.path.join(dirname[len(directory):], filename[:-4]))						
					else:	
						files.append(os.path.join(dirname[len(directory):], filename))				
	return files

def file_exists(p,f):
 return os.path.exists(os.path.join(p,f))

def save_list_to_file(the_list,filename):
	the_list.sort()
	fp = open(filename, 'w')
	for i in the_list:
		if i:
			fp.write("%s\n" % i)

def get_list_from_file(filename):
	if os.path.isfile(filename):	
		with open(filename) as f:
			return f.read().splitlines()	
	else:
		return []

def delete(p,f):
	path = os.path.join(p,f)
	
	if os.path.exists(path):
		if not (os.path.isdir(path) and os.listdir(path)):
			try:
				os.remove(path)
			except:
				logger.error('Error deleting %s' % path)

def recycle(p,f):
	path = os.path.join(p,f)
	if os.path.exists(path):
		if not (os.path.isdir(path) and os.listdir(path)):
			new_path = config.RECYCLE_BIN + path[len(config.IMAGES_DIRECTORY):]
			logger.info('Renaming %s to %s' % (path, new_path))
			os.renames(path, new_path)

def remove_empty_folders(path):
  if not os.path.isdir(path):
    return
  
  files = os.listdir(path)
  if len(files):
    for f in files:
      fullpath = os.path.join(path, f)
      if os.path.isdir(fullpath):
        remove_empty_folders(fullpath)

  # if folder is empty, delete it
  files = os.listdir(path)
  if len(files) == 0:
    logger.debug("Removing empty folder: %s" % path)
    os.rmdir(path)

def ensure_path(path):
	if not os.path.lexists(path):
		os.makedirs(path)
		logger.debug('Created directory %s' % path)



# setting up the log
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.FileHandler(config.LOG_FILE)
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
handler.setFormatter(formatter)
logger.addHandler(handler)

socket.setdefaulttimeout(200) # to avoid timeouts that do not trigger errors


######################################################################################

with flock (config.LOCK_FILE):
	logger.debug('File syncronisation started')


	if not os.path.isdir(config.IMAGES_DIRECTORY):
		logger.error('Cannot find IMAGES_DIRECTORY: %s. Exiting' % IMAGES_DIRECTORY)
		die()



	# # # Downloads new photos from FTP (e.g Eye-fi)
	
	ftp_local_dir_full_path = os.path.join(config.IMAGES_DIRECTORY,config.FTP_LOCAL_DIR)
	ensure_path(ftp_local_dir_full_path)
	logger.debug('Opening connection to ftp')
	cmd = "lftp -e 'cd %s; lcd %s; mget *.* -E; bye' -u %s,%s %s" \
		% (config.FTP_REMOTE_DIR, ftp_local_dir_full_path,config.FTP_USER, \
		config.FTP_PASSWORD, config.FTP_HOST)
	proc = subprocess.Popen([cmd],stdout=subprocess.PIPE,stderr=subprocess.PIPE,shell=True)

	stderr_list = proc.stderr.read().splitlines()
	stdout_list = proc.stdout.read().splitlines()

	#pprint.pprint(stderr_list)
	#pprint.pprint(stdout_list)

	if len(stderr_list) > 2 and 'cd ok' in stderr_list[0] and \
		'lcd ok' in stderr_list[1] and 'no files found' in stderr_list[2]:
		logger.debug("No new files on FTP")
	elif len(stdout_list) > 1 and 'files transferred' in stdout_list[1]:
		logger.debug(stdout_list[1] + ' from ftp')
	else:
		for l in stderr_list:
				logger.debug('LFTP error: %s' % l)
		for l in stdout_list:	
				logger.debug('LFTP stdout: %s' % l)

	
	
	# # # Downloads new photos from Dropbox (phone)

	logger.debug('Starting dropbox phone camera download')

	if config.APP_KEY == '' or config.APP_SECRET == '':
		exit("You need to set your APP_KEY and APP_SECRET")

	session = StoredSession(config.APP_KEY, config.APP_SECRET, access_type=config.ACCESS_TYPE)
	session.load_creds()

	if not session.is_linked():
		session.link()
	logger.debug("Dropbox login ok")

	db_client = client.DropboxClient(session)
	#print "linked account:", client.account_info()

	resp = db_client.metadata(config.DROPBOX_REMOTE_SOURCE_DIR)
	
	if 'contents' in resp:
		for f in resp['contents']:
			name = os.path.basename(f['path'])		
			move_to = config.DROPBOX_REMOTE_MOVE_TO
			move_remote_file = False
			DROPBOX_LOCAL_DIR_FULL = os.path.join(config.IMAGES_DIRECTORY,config.DROPBOX_LOCAL_DIR)

			if not f['is_dir']:		
				if file_exists(DROPBOX_LOCAL_DIR_FULL, name): #or file_exists(config.DROPBOX_LOCAL_DIR_FULL_ALT, name):
					logger.debug('Skipping "%s", already downloaded' % name)
					move_remote_file = True
				else:

					try:				  
						logger.debug('Downloading "%s"' % name)
						fp, metadata = db_client.get_file_and_metadata(config.DROPBOX_REMOTE_SOURCE_DIR + "/" + name)
						#logger.debug('http response received, downloading...')
						to_file = open(os.path.join(DROPBOX_LOCAL_DIR_FULL,name), "wb")
						#to_file.write(fp.read())
												
						while True:
							buf = fp.read(1048576)
							if buf=="": break
							to_file.write(buf)						
						to_file.close()
						#logger.debug('download complete and file saved')

						"""
						#hack to split stuff from different phones connected to same db account (ihpone and android)
						default_source = True				
						if os.path.splitext(name)[1].lower() in ['.jpeg','.jpg']:
							f = open(os.path.join(config.DROPBOX_LOCAL_DIR_FULL,name), 'rb')
							tags = EXIF.process_file(f, stop_tag='Image Model', details=False)
							if str(tags.get('Image Make')) == 'Sony Ericsson':
								default_source = False							
						elif os.path.splitext(name)[1].lower() == '.mp4':
							default_source = False
						if not default_source:																	
							logger.debug('Moving file to %s' % config.DROPBOX_LOCAL_DIR_FULL_ALT)
							move_to = config.DROPBOX_REMOTE_MOVE_TO_ALT
							fp.close()			
							os.renames(os.path.join(config.DROPBOX_LOCAL_DIR_FULL,name),os.path.join(config.DROPBOX_LOCAL_DIR_FULL_ALT,name))
						"""
						move_remote_file = True
					except Exception as e:
						# This happens from time to time due to timeouts etc. 
						# Don't worry - the file will most likely be copied the next time the script runs
						logger.debug('Unable to download "%s" due to error: %s' % (name, e))
						delete(DROPBOX_LOCAL_DIR_FULL,name)	# remove partial downloads

				if move_remote_file:
					try: 
						db_client.file_move(config.DROPBOX_REMOTE_SOURCE_DIR + "/" + name, move_to  + "/" + name)
					except Exception as ee:
						logger.debug('Unable to move remote file from "%s" to "%s" due to error: ee' % (name, move_to, ee))
	
	else:
		logger.debug('No new files in Dropbox')
	
	# # # CHECK IF IMAGES HAVE BEEN DELETED IN DROPBOX
	
	
	# find last dropbox delta cursor
	if os.path.isfile(config.DROPBOX_CURSOR_FILE):	
		with open(config.DROPBOX_CURSOR_FILE) as f:
			db_cursor = f.read().strip()	
	else:
		db_cursor = None

	resp = db_client.delta(db_cursor, path_prefix = '/' + config.DROPBOX_TARGET_DIR[:-1])

	# Only gives first 2000 entries. Script might need to run a couple of times before everything is in sync
	entries = resp['entries']

	logger.debug('Det er %s entries i Dropbox delta' % len(entries))

	dropbox_files = get_list_from_file(config.DROPBOX_LIST_FILE)
	
	for entry in entries:
		path = entry[0]
		metadata = entry[1]
		if metadata == None:		
			
			# should not be neccesarry due to path_prefix now part of delta API call
			if path[1:len(config.DROPBOX_TARGET_DIR)+1] == config.DROPBOX_TARGET_DIR:
				file_to_delete = path[len(config.DROPBOX_TARGET_DIR)+1:]			
				file_to_delete = file_to_delete.decode('ascii').encode('utf8')
				logger.debug("file %s deleted on dropbox" % file_to_delete)
				

				for i, dbf in enumerate(dropbox_files):
					if dbf.lower() == file_to_delete:
						logger.debug("file %s deleted via dropbox - deleting local medium file" % dbf)
						dropbox_files[i] = ''
						delete(config.MEDIUM_DIRECTORY,dbf)
						break

	save_list_to_file(dropbox_files,config.DROPBOX_LIST_FILE)

	fp = open(config.DROPBOX_CURSOR_FILE, 'w')
	fp.write("%s" % resp['cursor'])
	fp.close()

	
	# # # CHECKS FOR DELETED FILES

	
	prev_image_files = get_list_from_file(config.IMAGES_LIST_FILE)
	current_image_files = get_file_list(config.IMAGES_DIRECTORY)
	medium_image_files = get_file_list(config.MEDIUM_DIRECTORY)
	thumb_image_files = get_file_list(config.THUMB_DIRECTORY, True)
	
	#save_list_to_file(medium_image_files,'med_bilder.txt')
	
	
	if set(prev_image_files) == set(current_image_files) == set(medium_image_files) == set(thumb_image_files):
		logger.debug("No added or deleted files on disk")
	else:
		logger.debug("Files have been added or deleted on disk")
		
		if len(prev_image_files) == 0:
			logger.debug('No images list (%s) found. Cleaning up ' % config.IMAGES_LIST_FILE)		
			missing_images = [item for item in medium_image_files if not item in current_image_files]				
		else:					
			missing_images = [item for item in prev_image_files if not item in current_image_files]		
			missing_images.extend([item for item in prev_image_files if not item in medium_image_files])	
	
		if missing_images:
			for mi in missing_images:			
				delete(config.THUMB_DIRECTORY,mi + '.png')
				delete(config.MEDIUM_DIRECTORY,mi)
				recycle(config.IMAGES_DIRECTORY,mi)
				logger.debug('Deleted "%s" from disk' % mi) 

		# This approach deletes too many folders. Probably better to ensure that folders are synced the same way as files		
		#remove_empty_folders(config.MEDIUM_DIRECTORY)
		#remove_empty_folders(config.THUMB_DIRECTORY)
				
		prev_image_files = [x for x in prev_image_files if not x in missing_images]
			
		# probably best to save list, next step could take forever
		save_list_to_file(prev_image_files,config.IMAGES_LIST_FILE)

		# # # DELETES THUMBNAILS THAT ALREADY SHOULD HAVE BEEN DELETED
		
		thumbs_to_delete = [item for item in thumb_image_files if not item in current_image_files]
		for t in thumbs_to_delete:
			logger.debug('Deleted thumbnail of "%s" from disk' % t)  
			delete(config.THUMB_DIRECTORY,t+'.png')

		
	# # # CREATES MEDIUM VERSIONS FOR NEW IMAGES

	current_image_files = get_file_list(config.IMAGES_DIRECTORY)

	# consider ##		new_images = set(current_image_files) - set(prev_image_files)
	new_images = [item for item in current_image_files if not item in prev_image_files]

	for l in new_images:

		# check if it is a directory
		if l[-1] == os.sep:
			full_path = os.path.join(config.MEDIUM_DIRECTORY,l)
			if not os.path.lexists(full_path):
				os.makedirs(full_path)
				logger.debug('Created directory %s' % full_path)

		# not directory			
		else:

			source = os.path.join(config.IMAGES_DIRECTORY,l)
			sink = os.path.join(config.MEDIUM_DIRECTORY,l)

			# Using http://www.rw-designer.com/photo-resizer-advanced for simplicity on windows				
			#call_str = 'PhotoResize.exe -X1024 -m -e -o -c"%s" "%s"' % (sink,source)								
			# previusly used -thumbnail but -resize seems to be faster and maintans EXIF-data
			call_str = 'convert -resize 1024 "%s" "%s"' % (source,sink)								

			if not file_exists(config.MEDIUM_DIRECTORY,l):

				if os.path.getsize(source) > 0:					
					logger.debug('Converting %s' % sink)	

					t1 = os.path.getmtime(source)					
					subprocess.call('jhead -autorot "%s"' % source, shell=True)
					t2 = os.path.getmtime(source)		
					if t1 != t2: 
						os.utime(source,(t1,t1))

					subprocess.call(call_str, shell=True)

					# keeps last modified date
					t1 = os.path.getmtime(source)
					os.utime(sink,(t1,t1))
				else:	

					logger.debug('Skipping and deleting %s, since it is 0 bytes' % l)
					delete(config.IMAGES_DIRECTORY,l)


			else:
				logger.debug('Skipping %s since it already exists' % l)

				
	# # # CREATES THUMBNAILS FOR NEW IMAGES

	medium_image_files = get_file_list(config.MEDIUM_DIRECTORY)
	new_images = [item for item in medium_image_files if not item in thumb_image_files]


	for l in new_images:
				
		# check if it is a directory
		if l[-1] == os.sep:				
			pass
		else:	
		
			source = os.path.join(config.MEDIUM_DIRECTORY,l)
			sink = os.path.join(config.THUMB_DIRECTORY,l + '.png')				
			path_to_write_to = os.path.dirname(sink)


			if not os.path.exists(path_to_write_to):
				logger.debug("Path does not exists, creating: %s" % path_to_write_to)
				os.makedirs(path_to_write_to)

			call_str = 'convert -resize 150x150 -background none -gravity center -extent 150x150 "%s" "%s"' % (source,sink)								

			if not file_exists(config.THUMB_DIRECTORY,l + '.png'):

				if os.path.getsize(source) > 0:					
					logger.debug('Creating thumbnail for %s' % sink)	

					t1 = os.path.getmtime(source)											
					subprocess.call(call_str, shell=True)
					# keeps last modified date
					t1 = os.path.getmtime(source)
					os.utime(sink,(t1,t1))


	# several hours may have lapsed so check that images still exists (not deleted) 
	# before updating config.IMAGES_LIST_FILE. Add to list instead of using list on disk
	# to avoid removing deleted files from image list
	current_image_files = get_file_list(config.IMAGES_DIRECTORY)
	new_images = [item for item in current_image_files if not item in prev_image_files]

	for new_image in new_images:
		if file_exists(config.MEDIUM_DIRECTORY,new_image):				
			prev_image_files.append(new_image)
		else:
			logger.debug('No medium version of %s created yet. Not added filelist' % new_image)

	save_list_to_file(prev_image_files,config.IMAGES_LIST_FILE)

# # # # #  ONE WAY SYNC TO DROPBOX # # # # #
	if not os.path.isfile(config.DROPBOX_LIST_FILE) or not filecmp.cmp(config.IMAGES_LIST_FILE, config.DROPBOX_LIST_FILE):

		images = get_list_from_file(config.IMAGES_LIST_FILE)
		dropbox_files = get_list_from_file(config.DROPBOX_LIST_FILE)

		new_images = [item for item in images if not item in dropbox_files]		
		images_to_be_deleted = [item for item in dropbox_files if not item in images]		

		logger.debug("Syncing changes to drobox")

		session = StoredSession(config.APP_KEY, config.APP_SECRET, access_type=config.ACCESS_TYPE)
		session.load_creds()
		if not session.is_linked():
			session.link()
		db_client = client.DropboxClient(session)

		deleted_images = []
		for c,i in enumerate(images_to_be_deleted):
			try:
				db_client.file_delete(config.DROPBOX_TARGET_DIR + '/' + i)
				logger.debug('Deleting "%s" from drobox' % i)
			except Exception as e:
				logger.debug('Unable to delete "%s" from dropbox due to error: %s' % (i, e))
			
			deleted_images.append(i)
		
			if c%50 == 0: 
				dropbox_files = [x for x in dropbox_files if not x in deleted_images]
				save_list_to_file(dropbox_files,config.DROPBOX_LIST_FILE)
				deleted_images = []
			
			dropbox_files = [x for x in dropbox_files if not x in deleted_images]
			save_list_to_file(dropbox_files,config.DROPBOX_LIST_FILE)
			deleted_images = []
		
		cc = 0
		for i in new_images:	
			if file_exists(config.MEDIUM_DIRECTORY,i):
				if i[-1] is not os.sep: 
					cc = cc+1	
					local_file_pointer = open(os.path.join(config.MEDIUM_DIRECTORY,i), "rb")				
					logger.debug('Uploading %s' % i)
					try:			
						db_client.put_file(config.DROPBOX_TARGET_DIR + '/' + i, local_file_pointer, overwrite=True)
						dropbox_files.append(i)
					except Exception as e:
						logger.debug('Unable to upload "%s" due to error: %s' % (i, e))
				
				
					if cc%10 == 0: 
						save_list_to_file(dropbox_files,config.DROPBOX_LIST_FILE)
						logger.debug('saved dropbox file')
				
					if cc >= 800: 
						save_list_to_file(dropbox_files,config.DROPBOX_LIST_FILE)
						logger.debug('Uploaded %s images, stopping for now' % cc)
						break
										
				else:
					try:			
						dropbox_files.append(i)
						db_client.file_create_folder(config.DROPBOX_TARGET_DIR + '/' + i)					
					except Exception as e:
						logger.debug('Unable to create directory "%s" due to error: %s' % (i, e))
		
		save_list_to_file(dropbox_files,config.DROPBOX_LIST_FILE)
		logger.debug('Dropbox upload complete')	
	else:
		logger.debug("No changes needs to be synced to dropbox")	
 
logger.debug('Sync complete')
