#! /bin/bash

#The goal of this script is to install and set up everything needed
#in order to run Phtobx. The current status is that it lists most of 
#the steps needed. Commands/script should be executed as root

# Commands to download and launch this script
# wget http://f9.no/phtobx/phtobx.tar.gz
# tar -xzf phtobx.tar.gz
# chmod 744 phtobx/install.sh
# sudo ./phtobx/install.sh


### INSTALLS NEEDED SOFTWARE ###

# Update the linux system and install python module installer
apt-get update -y
apt-get install -y python-pip

# Install lftp (used to download images from ftp)
apt-get install -y lftp
# Install imagemagick used to convert photos
apt-get install -y imagemagick
# Install jhead used to make sure orientation is correct on photos
apt-get install -y jhead
# Install python dropbox client
pip install -y dropbox
# Install flask (web framework)
pip install -y Flask
# Install samba
apt-get install -y samba samba-common-bin


### MOUNT USB DRIVE AND CONFIGURE SAMBA (NETWORK DRIVE)

mkdir -p /home/shares/photos/
# Add the mount information to /etc/fstab
cp /etc/fstab /etc/fstab.old
echo "/dev/sda1 /home/shares/photos auto owner,user,iocharset=utf8,umask=000 0 0" >> /etc/fstab
# Reloads the mounts
mount -a

# configure samba
cp /etc/samba/smb.conf /etc/samba/smb.conf.old

# Configures a new share (appending text to end of smb.conf)
echo "[Photos]" >> /etc/samba/smb.conf
echo "path = /home/shares/photos" >> /etc/samba/smb.conf
echo "create mask = 0660" >> /etc/samba/smb.conf
echo "directory mask = 0771" >> /etc/samba/smb.conf
echo "read only = no" >> /etc/samba/smb.conf

# Adds new user to samba / pi-box. It might be a great idea to change username and password to somthing else
UNAME="photo"
PASS="photo"
useradd $UNAME -m n-G users
echo $UNAME:$PASS | chpasswd
echo "$PASS\n$PASS" | smbpasswd -as $UNAME
/etc/init.d/samba restart


### CREATE FOLDERS ###

# makes sure directory is writeable
chmod 777 phtobx/.
chmod 777 phtobx/*.*

# creates directories for storing the photos
chmod 777 /home/shares/photos/
mkdir /home/shares/photos/original
mkdir /home/shares/photos/medium
mkdir /home/shares/photos/thumb
mkdir /home/shares/photos/_trashcan
mkdir /home/shares/photos/_camera
mkdir /home/shares/photos/_phone

# creates symbolic linck between web root and photo share
ln -s /home/shares/photos/ phtobx/static/img


### ADD TO CRONTAB ###

# Adds scripts to pi's corntab
su pi -c "crontab -l > crontmp"
echo "*/5 * * * *  python /home/pi/phtobx/sync.py > /home/pi/phtobx/sync.log 2>&1" >> crontmp
echo "@reboot sudo python /home/pi/phtobx/httpd.py > /dev/null 2>&1 &"  >> crontmp
su pi -c "crontab crontmp"
rm crontmp
