import  os
import json


from flask import Flask
from flask import render_template, send_from_directory

app = Flask(__name__)

import config

app.config['MEDIUM_DIRECTORY'] = config.MEDIUM_DIRECTORY
# link photo folder to  'static/img/' directory ln -s ../bilder/ img
# An alternativ is to use flask.send_from_directory 
app.config['ORIGINAL_HTTP_DIRECTORY'] = '/static/img/original/'
app.config['MEDIUM_HTTP_DIRECTORY'] = '/static/img/medium/'
app.config['THUMB_HTTP_DIRECTORY'] = '/static/img/thumb/'

@app.route("/")
def menu():

	def get_directory_structure(rootdir):
	    
	    def fix_dict(d):
	        for key, value in d.iteritems():                
	            if isinstance(value, dict) and len(value) == 0:
	                d[key] = ''         
	            elif isinstance(value, dict):           
	                d[key] = fix_dict(value)
	        return d    

	    dir = {}
	    rootdir = rootdir.rstrip(os.sep)
	    start = rootdir.rfind(os.sep) + 1
	    first = True
	    for path, dirs, files in os.walk(rootdir):
	        
	        folders = path[start:].split(os.sep)
	        subdir = dict.fromkeys(files)
	        
	        subdir = {}
	        if len(dirs) > 0 and len(files) > 0:
	        	subdir['.'] = '' 	
	        
	    	parent = reduce(dict.get, folders[:-1], dir)
	    	parent[folders[-1]] = subdir

	    dir = next(dir.itervalues()) # removes sourounding folder
	    dir = fix_dict(dir)    
	    
	    return dir

	directory_listing = get_directory_structure(app.config['MEDIUM_DIRECTORY'])

	folder_string = json.dumps(directory_listing)

	#mark_safe(simplejson.dumps(value))

	return render_template('menu.html', folder_string = folder_string)


@app.route("/<path:path>")
def gallery(path):    

	if path == '+':
		path = ''
	
	current_dir = app.config['MEDIUM_DIRECTORY'] + path
	
	os.chdir(current_dir)
	files = filter(os.path.isfile, os.listdir(current_dir))
	#files.sort(key=lambda x: os.path.getmtime(os.path.join(directory, x)))
	files.sort()


	return render_template('gallery.html', images = files, path = path)


@app.route('/favicon.ico')
def favicon():
    return send_from_directory(os.path.join(app.root_path, 'static'),
                               'favicon.ico', mimetype='image/vnd.microsoft.icon')



if __name__ == "__main__":
    app.debug = True
    app.run(host='0.0.0.0',port=80)