PHOTOS_ROOT = '/home/shares/photos/'

# FTP stuff
FTP_HOST = ''
FTP_USER = ''
FTP_PASSWORD = ''
FTP_REMOTE_DIR = '/current/'
FTP_LOCAL_DIR = '_camera/' # relative to original directory

# Dropbox stuff
APP_KEY = '' # you find these at http://www.dropbox.com/developers/apps
APP_SECRET = ''
ACCESS_TYPE = 'dropbox'  # should be 'dropbox' or 'app_folder' as configured for your app


# Dropbox download sync (phone)
DROPBOX_REMOTE_SOURCE_DIR = 'Camera Uploads/' 
DROPBOX_REMOTE_MOVE_TO = 'Camera Uploads/_downloaded/'
DROPBOX_LOCAL_DIR = '_phone/'  # relative to "original" directory


# Dropbox upload sync
DROPBOX_TARGET_DIR = 'photos/'


#Normally no need to edit below this line
#----------------------------------------------------------------------------

import os

script_path = os.path.dirname(os.path.realpath(__file__))

# Files used to keep track of files and execution
IMAGES_LIST_FILE = os.path.join(script_path,'local_photo_list')
LOCK_FILE = os.path.join(script_path,'_lockfile_')
LOG_FILE = os.path.join(script_path,'sync.log')
DROPBOX_LIST_FILE = os.path.join(script_path,'dropbox_photo_list')
DROPBOX_CURSOR_FILE = os.path.join(script_path,'dropbox_cursor')
DROPBOX_TOKEN_FILE = os.path.join(script_path,'dropbox_token')


IMAGES_DIRECTORY = PHOTOS_ROOT + 'original/'
MEDIUM_DIRECTORY = PHOTOS_ROOT + 'medium/'
THUMB_DIRECTORY = PHOTOS_ROOT + 'thumb/'
RECYCLE_BIN = PHOTOS_ROOT + '_trashcan/'

IMAGE_TYPES = ['.jpeg','.jpg','.png','.gif']
IGNORE_PATHS = [RECYCLE_BIN,'picasaoriginals'] 